"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BehaviorEventCallbacks = exports.CallbackType = exports.CustomFunctions = void 0;
class CustomFunctions {
}
exports.CustomFunctions = CustomFunctions;
var CallbackType;
(function (CallbackType) {
    CallbackType[CallbackType["None"] = 0] = "None";
    CallbackType[CallbackType["Behavior"] = 1] = "Behavior";
    CallbackType[CallbackType["BehaviorCustom"] = 2] = "BehaviorCustom";
    CallbackType[CallbackType["CustomFunction"] = 3] = "CustomFunction";
})(CallbackType || (exports.CallbackType = CallbackType = {}));
class BehaviorEventCallbacks {
    static invokeCallbackFromInputs(script, eventName) {
        const callbackType = script.callbackType;
        if (isNull(callbackType)) {
            print("Warning: Wrong Callback Type input.");
        }
        switch (callbackType) {
            case CallbackType.Behavior:
                return BehaviorEventCallbacks.invokeCallbackFromBehavior(script, eventName);
            case CallbackType.BehaviorCustom:
                return BehaviorEventCallbacks.invokeCallbackFromBehaviorSystem(script, eventName);
            case CallbackType.CustomFunction:
                return BehaviorEventCallbacks.invokeCallbackFromScriptAPI(script, eventName);
        }
    }
    static invokeCallbackFromBehavior(script, eventName) {
        return () => {
            var _a;
            const behaviors = script[eventName + "Behaviors"];
            if (!behaviors) {
                print("Warning: No event with name: " + eventName);
                return;
            }
            for (const behavior of behaviors) {
                (_a = behavior === null || behavior === void 0 ? void 0 : behavior.trigger) === null || _a === void 0 ? void 0 : _a.call(behavior);
            }
        };
    }
    static invokeCallbackFromBehaviorSystem(script, eventName) {
        return () => {
            if (!global.behaviorSystem) {
                print("The global behavior system has not been instantiated yet! Make sure a Behavior script is present somewhere!");
                return;
            }
            const triggerNames = script[eventName + "CustomTriggers"];
            for (const triggerName of triggerNames) {
                if (triggerName.length == 0) {
                    print("You are trying to send an empty string custom trigger!");
                    continue;
                }
                global.behaviorSystem.sendCustomTrigger(triggerName);
            }
        };
    }
    static invokeCallbackFromScriptAPI(script, eventName) {
        return (eventData) => {
            const listeners = script[eventName + "Functions"];
            if (!listeners) {
                return;
            }
            for (const listener of listeners) {
                if (listener.function.length == 0) {
                    print("You are trying to invoke an empty string function!");
                    continue;
                }
                if (!listener.script[listener.function]) {
                    print("Cannot find " + listener.function + " function in the assigned " + listener.script.getSceneObject().name + " script.");
                    continue;
                }
                else if (typeof listener.script[listener.function] !== "function") {
                    print("There is a " + listener.function + " property in the assigned " + listener.script.getSceneObject().name + " script, but it's not a function.");
                    continue;
                }
                listener.script[listener.function](eventData);
            }
        };
    }
}
exports.BehaviorEventCallbacks = BehaviorEventCallbacks;
//# sourceMappingURL=BehaviorEventCallbacks.js.map